 ; Ŀ
 ;   Junc - junction box maker.                                            
 ;   Copyright 1998, 2001, 2005 by Rocket Software Ltd.                    
 ;   A better routine than you might think.                                
 ; 

 ; Ŀ
 ;   Subroutine Junc - draw the JB.                                        
 ;   Arguments: Numtrm, the number of terminals.                           
 ;              Isana, the analog/t or discrete/nil flag.                  
 ;              Pa, the insertion point.                                   
 ;   Calls She to draw sets of two terminals,                              
 ;     and Shez to add shields and shield terminals beneath them.          
 ;   Returns nothing.                                                      
 ; 
 (DEFUN JUNC (numtrm isana pa / pasav num trmnum tagnam len total spares pb
                                                  pc pd pe pf ptx p1 p2 p3 p4)
  (setq pasav pa)
 ; Ŀ
 ;   Insert the cable name lamicoid block.                                 
 ; 
  (setvar "clayer" "misc")
  (command "insert" "terminal-lamicoid"
                    (polar pa (/ pi 2) 2.5) "1" "" "" "CC-XXX")
  (setq trmnum 1)
  (setq num 0)
 ; Ŀ
 ;   Draw the terminals and wires etc.                                     
 ; 
  (while (and (> numtrm num) (setq tagnam (itoa num)))
         (setq num (1+ num))
         (she pa tagnam (itoa trmnum) t "A" ())
         (setq pa (polar pa (* pi 1.5) 5))
         (setq trmnum (1+ trmnum))
         (she pa tagnam (itoa trmnum) () "B" ())
         (setq trmnum (1+ trmnum))
 ; Ŀ
 ;   If this is an analog JB, draw the shields etc.                        
 ; 
         (if isana
             (progn
                  (setq pa (polar pa (* pi 1.5) 5))
                  (shez pa ())))
         (setq pa (polar pa (* pi 1.5) 5)))
 ; Ŀ
 ;   Finished making wiring: draw the Jb outline.                          
 ; 
  (setq p1 (polar (polar pasav (/ pi 2) 20) 0 52.5))
  (setq p2 (polar p1 pi 115))
  (setq p3 (polar (polar pa (* pi 1.5) 10) 0 52.5))
  (setq p4 (polar p3 pi 115))
  (setvar "clayer" "misc")
  (command ".pline" p2 p1 p3 p4 "c")
  (command ".change" "l" "" "p" "colour" "cyan" "")
 ; Ŀ
 ;   Add the cable back to the control panel.                              
 ; 
  (setvar "clayer" "field")
  (setq pa1 (polar (polar pasav pi 52.5) (* pi 1.5) 2.5)) 
  (setq pa2 (polar (polar p4 0 10) (* pi 1.5) 20)) 
  (command ".line" pa1 pa2 "")
 ; Ŀ
 ;   Line break and text.                                                  
 ; 
  (setvar "clayer" "text")
  (command ".text" "m" pa2 2.5 0 "~")
  (command ".text" "c" (polar pa2 (* pi 1.5) 5) 2.5 0 "CONT. ON DWG.")
  (command ".text" "" "XXX")
 ; Ŀ
 ;   And a wiretag.                                                        
 ; 
  (setq pa1 (polar pa2 (/ pi 2) 10))
  (command ".pline" (setq pc (polar pa1 0 2.5))
                    (setq pc (polar pc (/ pi 2) 1.25))
                    (setq pc (polar pc pi 5))
                    (setq pc (polar pc (* pi 1.5) 1.25))
                    (setq pc (polar pc 0 10)) "")
  (setq pc (polar (polar pc (* pi 1.5) 2.5) 0 12.5))
  (setvar "clayer" "misc")
  (command ".insert" "cabletag" pc "1" "" 0 "CC-XXX")
 (princ))
 ; Ŀ
 ;   Junc end.                                                             
 ; 

 ; Ŀ
 ;   She - draw a single terminal with wires etc.                          
 ;   Takes five arguments:                                                 
 ;            Pa     - the terminal block insertion point                  
 ;            Tagnam - the device name                                     
 ;            Termno - the terminal number                                 
 ;            Endp   - insert endset flag                                  
 ;            Aorb   - presume either A or B wire number                   
 ;            Sparep - the spare flag                                      
 ; 
 (DEFUN SHE (pa tagnam termno endp aorb sparep / pb pc ptx pd pe pf entt panel)
  (setvar "clayer" "misc")
  (command "insert" "jb-terminal" pa "1" "" "" termno)
  (if (null sparep)
      (progn
           (setq pb (polar pa 0 12.5))
           (setq pc (polar pa 0 22.5))
           (setq ptx (polar pa 0 32.5))
           (setq pd (polar pa 0 42.5)) 
           (setq pe (polar pa 0 72.5)) 
           (setvar "clayer" "field")
           (command "line" pb pc "")
           (setvar "clayer" "text")
           (command ".text" "m" ptx "2.5" "0" (strcat "XXX" aorb))
           (setvar "clayer" "field")
           (command "line" pd pe "")
           (if endp
               (progn
                    (command "insert" "*endset" pe "1" "")
                    (setq entt (entget (entlast)))
                    (entmod (subst (cons 1 tagnam) (assoc 1 entt) entt))))))
  (setq pb (polar pa pi 12.5))
  (setq pc (polar pa pi 22.5))
  (setq ptx (polar pa pi 32.5))
  (setq pd (polar pa pi 42.5)) 
  (setq pe (polar pa pi 50)) 
  (setvar "clayer" "field")
  (command "line" pb pc "")
  (setvar "clayer" "text")
  (if sparep
      (command ".text" "m" ptx "2.5" "" "SPARE")
      (command ".text" "m" ptx "2.5" "" (strcat "XXX" aorb)))
  (setvar "clayer" "field")
  (command "line" pd pe "")
  (command ".arc" pe "e" (polar (polar pe pi 2.5) (* pi 1.5) 2.5) "a" "90")
  (setvar "clayer" "misc")
  (setq panel (cond (sparep "SPARE")
                    (endp "XXX1")
                    (t "XXX2")))
 (princ))
 ; Ŀ
 ;   She end.                                                              
 ; 

 ; Ŀ
 ;   Shez - add shields and terminals beneath a pair of wires & terminals. 
 ;   Takes two arguments, Pa: the terminal block insertion point, and      
 ;   sparep, the This_a_spare flag.                                        
 ; 
 (DEFUN SHEZ (pa sparep / ptx ceco clay)
  (setvar "clayer" "misc")
  (setq ceco (getvar "cecolor"))
  (setvar "cecolor" "green")
  (setq clay (getvar "clayer"))
  (setvar "clayer" "field")
  (if (null sparep)
      (progn
           (setq ptx (polar pa 0 62.5))
           (command "insert" "shield-cut" ptx "1" "" "")
           (setq ptx (polar pa 0 12.5))
           (command "insert" "shield-gr" ptx "1" "" "")))
  (setq ptx (polar pa pi 77.5))
;  (command "insert" "shield-gr" ptx "1" "" "")
  (setq ptx (polar pa pi 12.5))
  (command "insert" "shield-gr" ptx "-1" "1" "")
  (setq ptx (polar pa pi 90))
  (setvar "cecolor" ceco)
  (setvar "clayer" "misc")
  (command "insert" "jb-terminal" pa "1" "" "" "SHIELD")
;  (command "insert" "jb-terminal" ptx "1" "" "" "SHIELD")
  (setvar "clayer" clay)
 (princ))
 ; Ŀ
 ;   Shez end.                                                             
 ; 

 ; Ŀ
 ;   Junc.                                                                 
 ; 
 (DEFUN C:JUNC (/ *error* osmo suni pa insp num)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq osmo (getvar "osmode"))
  (setvar "osmode" 0)
  (setq suni (getvar "insunits"))
  (setvar "insunits" 0)
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
  (defun *error* (shk)
   (if shk (print shk))
   (setvar "osmode" osmo)
   (setvar "insunits" suni)
   (command "undo" "end")
  (princ))
 ; Ŀ
 ;   Set up the layers.                                                    
 ; 
  (if (null c:malaya) (load "malaya"))
  (malaya "field")
  (malaya "misc")
  (malaya "text")
 ; Ŀ
 ;   Get a start point.                                                    
 ; 
  (setq pa (getpoint "JB Start: "))
 ; Ŀ
 ;   See what type of JB this is.                                          
 ; 
  (initget 0 "Analog Discrete 4-20")
  (Setq insp (getkword "JB type: Analog (4-20)/<Discrete>: "))
  (cond ((or (null insp) (= insp "Discrete"))
         (setq num (getint "Number of pairs <12>: "))
         (if (null num) (setq num 12))
         (junc num () pa))
        ((or (= insp "Analog") (= insp "4-20"))
         (setq num (getint "Number of pairs <12>: "))
         (if (null num) (setq num 12))
         (junc num t pa))
        (t (write-line "Impossible error.  Please check your reality.")))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* ())
 (princ))